*******************************************************************************
*                         680xx Grundprogramm portio                          *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                     Menpunkte IO-Lesen / IO-Setzen                         *
*******************************************************************************


ioread:                         * Wert von IO-Port lesen
 lea iomsg(pc),a0
 bsr headaclr                   * berschrift
 lea io1msg(pc),a0
 moveq #$33,d0
 moveq #10,d2
 bsr centertxt                  * Befehle
 bsr getadr                     * Adresse holen
 bcs carset                     * Fehler
 tst.l d0
 bmi.s io1rda                   * negativer Wert
 cmp.l #256, d0
 bge.s io1rda                   * Adresse ist grer 255
 or.l #$ffffff00, d0
 move #cpu, d1
 lsr #1, d1                     * CPU-Wert/2
 beq.s io1rda                   * 0 = 68008
 lsl.l d1, d0                   * Adresse mit CPU-Wert multiplizieren
io1rda:
 movea.l d0,a1                  * Adresse merken
io1rd:
 bsr.s ioprint                  * Ausgabe des Wertes
 bsr ki                         * Zeichen von Tastatur holen
 cmp.b #'D',d0
 bne.s io2rd
io11rd:                         * Dauernd ausgeben
 bsr sync                       * Mit 20 ms Abstand, damit Wert nicht flimmert
 beq.s io11rd
 bsr.s ioprint                  * Wert ausgeben
 bsr csts                       * Auf Zeichen von Tastatur warten
 beq.s io11rd                   * OK, kein Zeichen, also weiter ausgeben
 bsr ki                         * Sonst Zeichen holen
 cmp.b #$1b,d0                  * <ESC> = Ende
 beq carres
 cmp.b #'M',d0                  * 'M' = Ende
 beq carres
 cmp.b #'S',d0                  * 'S' = Stop
 beq.s io1rd
 cmp.b #'R',d0                  * 'R' = Neue Adresse eingeben
 beq.s ioread
 bra.s io11rd                   * Sonst weiter ausgeben

io2rd:
 cmp.b #$1b,d0                  * <ESC> = Ende
 beq carres
 cmp.b #'M',d0                  * 'M' = Ende
 beq carres
 cmp.b #'R',d0                  * 'R' = Adresse neu eingeben
 beq ioread
 bra.s io1rd                    * Auf nchstes Zeichen warten

ioprint:                        * IO-Wert ausgeben
 lea ausbuf(a5),a0
 move.b (a1),d0
 bsr print2x                    * Hexadezimal ausgeben
 lea ausbuf(a5),a0
 moveq #$22,d0
 move #224,d1
 move #135,d2
 bsr textaus
 lea ausbuf(a5),a0
 move.b (a1),d0
 bsr print4d                    * Dezimal ausgeben
 move.b #' ',(a0)+
 move.b #' ',(a0)+              * Leerzeichen, damit bei weniger Stellen
 clr.b (a0)                     * gelscht wird
 lea ausbuf(a5),a0
 moveq #$22,d0
 move #150,d1
 bsr textaus
 lea ausbuf(a5),a0
 move.b (a1),d0
 bsr print8b                    * Und binr ausgeben
 lea ausbuf(a5),a0
 moveq #$22,d0
 moveq #100,d2
 bra textaus

iowrite:                        * Wert an IO-Port ausgeben
 lea iopmsg(pc),a0
 bsr headaclr                   * berschrift
 bsr getadr                     * Adresse holen
 bcs carset                     * Fehler
 tst.l d0
 bmi.s io1wr                    * negativer Wert
 cmp.l #256, d0
 bge.s io1wr
 or.l #$ffffff00, d0
 move #cpu, d1
 lsr #1, d1                     * CPU-Wert/2
 beq.s io1wr                    * 0 = 68008
 lsl.l d1, d0                   * Adresse mit CPU-Wert multiplizieren
io1wr:
 movea.l d0,a3                  * Adresse merken
 lea datamsg(pc),a0
 moveq #$22,d0
 moveq #20,d1
 move #150,d2
 bsr textprint                  * Text ausgeben 'DATA'
 lea einbuf(a5),a0
 moveq #90,d1
 moveq #30,d3
 bsr textein                    * Auszugebenden Wert holen
 bcs carset                     * Abbruch
 lea einbuf(a5),a0
 bsr wertmfeh                   * Wert berechnen
 bcs carset                     * Fehler
 move.b d0,(a3)                 * Wert ausgeben
 lea iop1msg(pc),a0
 moveq #$33,d0
 moveq #20,d2
 bsr centertxt                  * Befehle
iopw1:
 bsr ki                         * Auf Zeichen von Tastatur warten
 cmp.b #'R',d0                  * 'R' = neue Adresse eingeben
 beq.s iowrite
 cmp.b #$1b,d0                  * <ESC> = Ende
 beq.s iopw2
 cmp.b #'M',d0                  * 'M' = Ende
 bne.s iopw1
iopw2:
 rts
                                                  ion abfragen
 moveq #0,d0
 move.b ioflag(a5),d0           * 0 = Alte GDP / 1 = Neue GDP
 and.b #1,d0
rts

asserr:                         * Fehleranzahl nach d0.l
 moveq #0,d0                    * Wort innerhalb eines Langwortes
 move errcnt(a5),d0
rts

getcurxy:                       * Cursor Position nach d1.l / d2.l
 moveq #0,d1                    * Byte innerhalb Langwort
 moveq #0,d2
 move.b curx(a5),d1
 move.b cury(a5),d2
rts

setcurxy:                       * Neuer Cursor d1=curx d2